//%attributes = {}
// Method: bank_ AccountNumberCheck
// 2005.09.28-17:48:45 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: 
// Checks the correctness of a bank account number.
// Original method written for finnish bank accounts.
// ME 2005-09-27: added IBAN support
// ------------------------------------------------------------

C_TEXT:C284($0; $bank_tAccount; $bank_tIbanCode; $bank_tNumber)
C_LONGINT:C283($bank_lLength; $bank_lIndex; $bank_lFound; $bank_lSum; $bank_lCorrect)
C_LONGINT:C283($bank_lFirstNum; $bank_lCheckNum; $bank_lNewCheck; $bank_lDigit; $bank_lRemainder)
C_POINTER:C301($1)  //pointer to account number

$0:=""  //all OK - no error message
$1->:=_str_ ToUpper($1->)  // IBAN numbers may contain letters that must be _str_ ToUpper
$1->:=Replace string:C233($1->; " "; "")  // delete spaces
$bank_tAccount:=$1->
$bank_lLength:=Length:C16($bank_tAccount)

If (Character code:C91($bank_tAccount[[1]])>65)  // an IBAN number starts with a letter
	If ($bank_lLength<5)  // IBAN must be between 5 and 34 chars
		$0:=_lang Current("The account number is too short")
	Else 
		If ($bank_lLength>34)
			$0:=_lang Current("The account number is too long")
		Else 
			$bank_tIbanCode:=""
			$bank_lCorrect:=kTrue
			// check the digits and encode them into a number.
			For ($bank_lIndex; 1; $bank_lLength)
				$bank_lDigit:=Character code:C91($bank_tAccount[[$bank_lIndex]])
				Case of 
					: (($bank_lIndex<3) & (($bank_lDigit<65) | ($bank_lDigit>90)))
						$bank_lCorrect:=kFalse  // first two digits have to be letters
					: (($bank_lIndex>2) & ($bank_lIndex<5) & (($bank_lDigit<48) | ($bank_lDigit>57)))
						$bank_lCorrect:=kFalse  // next two have to be numbers
					: (($bank_lDigit<48) | ($bank_lDigit>90) | (($bank_lDigit>57) & ($bank_lDigit<65)))
						$bank_lCorrect:=kFalse  // iban may contain only numbers and _str_ ToUpper letters A-Z .            
					: (($bank_lDigit>64) & ($bank_lDigit<91))  // it's a letter, encode to number 10-35
						$bank_tIbanCode:=$bank_tIbanCode+String:C10($bank_lDigit-55)
					Else   // it's a number, add to code 
						$bank_tIbanCode:=$bank_tIbanCode+String:C10($bank_lDigit-48)
				End case 
			End for 
			If ($bank_lCorrect#kTrue)
				$0:=_lang Current("The account number is incorrect")
			Else 
				// the first 4 chars need to be moved to end. since the letters are converted,
				// now there are 6 chars to move.      
				$bank_tIbanCode:=$bank_tIbanCode+Substring:C12($bank_tIbanCode; 1; 6)
				$bank_tIbanCode:=Delete string:C232($bank_tIbanCode; 1; 6)
				// now the iban code is a long number represented as a string.
				// we need to calculate the remainder when the code is divided with 97.
				// this can be done in parts adding always the remainder in the 
				// beginning of the next part.
				$bank_lRemainder:=0
				Repeat 
					$bank_tNumber:=Substring:C12($bank_tIbanCode; 1; 9)  // divide in 9-number parts
					$bank_lRemainder:=Num:C11($bank_tNumber)%97
					$bank_tIbanCode:=Delete string:C232($bank_tIbanCode; 1; 9)
					If ($bank_tIbanCode#"")  // add the remainder to the beginning
						$bank_tIbanCode:=String:C10($bank_lRemainder)+$bank_tIbanCode
					End if 
				Until ($bank_tIbanCode="")
				// now the remainder has to be 1.      
				If ($bank_lRemainder#1)
					$0:=_lang Current("The account number is incorrect")
				End if 
			End if   // not correct form
		End if   //too long
	End if   // too short
Else   // if it doesn't start with a letter, it should be a finnish account number       
	$bank_tAccount:=Replace string:C233($bank_tAccount; "-"; "")  // remove dash
	$bank_lLength:=Length:C16($bank_tAccount)
	$bank_lFirstNum:=Num:C11($bank_tAccount[[1]])
	$bank_lCheckNum:=Num:C11($bank_tAccount[[$bank_lLength]])
	
	If ($bank_lLength<8)  // finnish account number must be between 8 and 14 chars without dash
		$0:=_lang Current("The account number is too short")
	Else 
		If ($bank_lLength>14)
			$0:=_lang Current("The account number is too long")
		Else 
			$bank_lFound:=kFalse
			// the first number identifies the bank, it must be 1, 2, 3, 4, 5, 6 or 8
			Case of 
					// nordea, shb, seb, danske bank, dnb nor, åab, sampo, tapiola
				: (($bank_lFirstNum=1) | ($bank_lFirstNum=2) | ($bank_lFirstNum=3) | ($bank_lFirstNum=6) | ($bank_lFirstNum=8))
					$bank_lFound:=kTrue
					// fill with zeros to 14 chars; fill after 6 numbers
					$bank_tAccount:=Insert string:C231($bank_tAccount; "0"*(14-$bank_lLength); 7)
					
					// säästöpankki, paikallisosuuspankki, aktia, osuuspankki, oko, okopankki
				: (($bank_lFirstNum=4) | ($bank_lFirstNum=5))
					$bank_lFound:=kTrue
					// fill with zeros to 14 chars; fill after 7 numbers
					$bank_tAccount:=Insert string:C231($bank_tAccount; "0"*(14-$bank_lLength); 8)
				Else 
					$0:=_lang Current("The account number is incorrect")+"."+ksSpace+_lang Current("Unable to recognize the bank")
			End case 
			
			If ($bank_lFound=kTrue)
				$bank_lSum:=0
				// sum up the 13 first numbers 
				// multiplying even-placed ones with 2 and odd-placed ones with 1
				For ($bank_lIndex; 1; 13)
					$bank_lNumber:=($bank_lIndex%2+1)*Num:C11($bank_tAccount[[$bank_lIndex]])
					$bank_lSum:=$bank_lSum+($bank_lNumber\10)
					$bank_lSum:=$bank_lSum+($bank_lNumber%10)
				End for 
				// subtract from the next full tenth, this is the check number          
				$bank_lNewCheck:=Round:C94($bank_lSum+4; -1)-$bank_lSum
				
				// now compare the check numbers
				If ($bank_lNewCheck#$bank_lCheckNum)
					$0:=_lang Current("The account number is incorrect")
				End if 
			End if   // bank not recognized
		End if   // too long
	End if   //too short
End if   // iban or national